   float4 ShadowOffsetPoint[11]={float4(0.0,0.0,0.0,0.0),
                                 float4(0.0,0.0,1.0,1.0),
                                 float4(0.0,0.0,1.0,1.0),
                                 float4(0.0,0.0,1.0,1.0),
                                 float4(0.0,0.0,0.5,0.5),
                                 float4(0.5,0.0,0.5,0.5),
                                 float4(0.0,0.5,0.5,0.5),
                                 float4(0.5,0.5,0.25,0.25),
                                 float4(0.75,0.5,0.25,0.25),
                                 float4(0.5,0.75,0.25,0.25),
                                 float4(0.75,0.75,0.25,0.25)};
   float4 ShadowOffsetSpot[11]={float4(0.0,0.0,0.0,0.0),
                                float4(0.25,0.5,0.25,-0.5),
                                float4(0.25,0.5,0.25,-0.5),
                                float4(0.25,0.5,0.25,-0.5),
                                float4(0.125,0.25,0.125,-0.25),
                                float4(0.375,0.25,0.125,-0.25),
                                float4(0.125,0.75,0.125,-0.25),
                                float4(0.3125,0.625,0.0625,-0.125),
                                float4(0.4375,0.625,0.0625,-0.125),
                                float4(0.3125,0.875,0.0625,-0.125),
                                float4(0.4375,0.875,0.0625,-0.125)};
   float2x3 PixelLighting(in float Array, in float4 WorldPos, in float3 Normals, in float3 ViewVec, in float Distribution, in float4 Disk1, in float4 Disk2)
      {
          float3 Light=0.0, Specular=0.0;
          float4 LightPosition=tex2Dlod(LightDataSampler,float4(Array,0.97265625,0.0,0.0))-WorldPos;
          float Attenuation=length(LightPosition.xyz);
          if(Attenuation<LightPosition.w) {
           float3 LightVec=LightPosition.xyz/Attenuation;
           Attenuation /=LightPosition.w;
           float4 LightColor=tex2Dlod(LightDataSampler,float4(Array,0.9765625,0.0,0.0));
           Light=DiffuseLight(LightVec,Normals,LightColor.xyz)*max(1.0/Attenuation-1.0,0.0);
           float4 LightSpot=tex2Dlod(LightDataSampler,float4(Array,0.98046875,0.0,0.0));
           Light *=SpotLight(LightVec,LightSpot.xyz,float2(LightSpot.w,LightColor.w));
           if(abs(LightColor.w+LightSpot.w)*Light.x>0.0) {
            float3 ShadowVec=LightPosition.xyz-Normals*2.5;
            float4x4 LightMat=float4x4(tex2Dlod(LightDataSampler,float4(Array,0.984375,0.0,0.0)),tex2Dlod(LightDataSampler,float4(Array,0.98828125,0.0,0.0)),tex2Dlod(LightDataSampler,float4(Array,0.9921875,0.0,0.0)),tex2Dlod(LightDataSampler,float4(Array,0.99609375,0.0,0.0)));
            float4 LightProj=mul(float4(ShadowVec,1.0),LightMat), LightTex=0.0;
            int SpotIndex=floor(LightColor.w), PointIndex=-floor(LightColor.w);
            if(PointIndex>0) {
             float3 CubeFace=abs(ShadowVec), CubeSign=sign(ShadowVec);
             CubeFace=max(1.0-floor(max(CubeFace.zxx,CubeFace.yzy)/CubeFace.xyz),0.0);
             LightTex.xy=(float2(-ShadowVec.z,ShadowVec.y*CubeSign.x)/ShadowVec.x*0.98)*CubeFace.x+(float2(ShadowVec.x*-CubeSign.y,ShadowVec.z)/ShadowVec.y*0.98)*CubeFace.y+(float2(ShadowVec.x,-ShadowVec.y*-CubeSign.z)/ShadowVec.z*0.98)*CubeFace.z;
             LightTex.xy *=float2(0.166666,0.25);
             LightTex.xy +=float2(0.167252+0.333333*CubeFace.y+0.666666*CubeFace.z,0.50039+dot(CubeSign,CubeFace)*0.25);
             LightTex.xy=ShadowOffsetPoint[PointIndex].xy+LightTex.xy*ShadowOffsetPoint[PointIndex].zw;
             PointIndex=min(PointIndex-1,3);
             Light *=step(Attenuation,tex2Dlod(Shadow2Sampler,LightTex)[PointIndex]);
            }
            if(SpotIndex>0) {
             LightTex.xy=ShadowOffsetSpot[SpotIndex].xy+(LightProj.xy/LightProj.w)*ShadowOffsetSpot[SpotIndex].zw;
             SpotIndex=min(SpotIndex-1,3);
             Light *=step(Attenuation,tex2Dlod(Shadow3Sampler,LightTex)[SpotIndex]);
            }
            SpotIndex=floor(LightSpot.w), PointIndex=-floor(LightSpot.w);
            if(PointIndex>0) {
             LightProj /=length(LightProj);
             LightTex.xy=0.3183*float2(atan2(-LightProj.z,LightProj.x),acos(LightProj.y));
             Light *=tex3Dlod(LightSampler,float4(0.5+LightTex.x*0.5,LightTex.y,(PointIndex-0.5)/LightingTexture.x,0.0));
            }
            if(SpotIndex>0) Light *=tex3Dlod(LightSampler,float4(0.5+(LightProj.xy/LightProj.w)*0.5,(SpotIndex-0.5)/LightingTexture.x,0.0));
           }
           #if Specularity == 1
            Specular=SpecularLight(LightVec+ViewVec,Normals,Distribution)*Light;
           #endif
          }
          return float2x3(Light,Specular);
      }